<?php
/**
 * Default category template
 * @package ninja
 */

get_header(); ?>

	<section id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>
			<div id="container">
				<section class="contact-2">
					<div class="container">
						<div class="row ntp50">
							<div class="col-md-10 col-md-offset-1 shadebg text-center">
								<?php the_archive_title( '<h5 class="page-title">', '</h5>' ); ?>
							</div>
						</div>
					</div>
				</section>
	 			<!-- .page-header -->

				<?php do_action('ninja_breadcrumbs'); ?>

				<div class="row nbp100">
					<div class="sidebar col-md-6 col-md-offset-3 text-center">
		          		<?php drop_down_cat(); ?>
		          	</div>
		          	<div class="content sidebar-content col-md-12">
		          		<ul class="post-listing row">
						<?php while ( have_posts() ) : the_post(); ?>
							<li class="col-md-4 bloglist">
							<a href="<?php the_permalink(); ?>">
								<div class="featured-img">
										<?php
										if ( has_post_thumbnail() ) {
											the_post_thumbnail('full');
										} 
										?>
								</div>
							 
								<div class="contents">
								<h4 class="title"><?php the_title(); ?></h4>
								<?php
								$terms = get_the_terms($post->ID, 'blog-category', true);
								$term = array_shift( $terms );
								?>
								<h6><?php echo $term->name; ?></h6>
							 </a>
							</li>
						<?php endwhile; ?>
						</ul>
						<?php do_action('ninja_navigation'); ?>
					</div><!-- .content -->

				</div>
			</div><!-- #container -->

		<?php else: ?>

			<?php get_template_part('content', 'coming-soon'); ?>

		<?php endif; ?>

		</main><!-- #main -->
	</section><!-- #primary -->

<?php get_footer(); ?>