<?php
/**
 * Ninja functions and definitions
 *
 * @package ninja
 */

 /**
  * @file - init.php
  * @desc - Contain standard script and function to initial project in beginning stage.
  * @path - theme template folder  > init.pp
 */
include "init.php";

/**
 * @return any - return templete section structure or custom query 
 * @desc - to organize the file structure and easy to debug script. this function will get the templete, php script or custom WP_QUERY from the component folder and apply to the give shortcode name.
 */
// add_shortcode( '<name-of-the-shortcode>', '<func-name>');
// function <func-name>(){
//     ob_start();

//     do_shortcode(get_template_part('components/<page-folder>/<feature-name>','<type>')); //example::do_shortcode(get_template_part('components/home/product-category','section'))
      
//     wp_reset_query();

//     return ob_get_clean(); 
// }

/**********
**** List Testimonials
*********/
add_shortcode( 'ninja_Testimonials', 'ninja_Testimonials' );
function ninja_Testimonials($atts, $content = null){

    $atts = shortcode_atts( array(
           'term'   => '',
    ), $atts );

    $term = $atts['term'];

    $postList ='';
    $postListNav ='';
    $html = '';
    
    $args = array(
            'post_type' => 'testimonial',
            'orderby' => 'id',
            'order'   => 'ASC',
            'posts_per_page' => '6',
            // 'tax_query' => array(
            //     array(
            //         'taxonomy' => 'testimonial-category',
            //         'terms'    => $term,
            //     ),
            // ),
        );
    $query = get_posts( $args ); 

    if ( $query ) :
        foreach ($query as $post) {
            
            $position = types_render_field("position", array("post_id"=>$post->ID, "output"=>"raw"));
            $age = types_render_field("age", array("post_id"=>$post->ID, "output"=>"raw"));
            $experience = types_render_field("experience", array("post_id"=>$post->ID, "output"=>"raw"));

            if ( has_post_thumbnail($post->ID) ) { // check if the post has a Post Thumbnail assigned to it.
                $thumb_id = get_post_thumbnail_id($post->ID);
                $thumb_url_array = wp_get_attachment_image_src($thumb_id, 'thumbnail-size', true);
                $thumb_url = $thumb_url_array[0];
            } 
            $post_content = apply_filters('the_content', get_post_field('post_content', $post->ID));

            $postList .= '<li>';
            $postList .= '<div class="block inner-nbox">';
            $postList .= '<div class="img-nbox">';
            $postList .= '<div class="img-wrapper"><img src="'.$thumb_url.'"/></div>';
            $postList .= '<h4 class="post-title">'.get_the_title($post->ID).'</h4>';
            $postList .= '<h5 class="post-title-sub">'.$position.'</h5>';
            $postList .= '<h5 class="post-title-sub">'.$age.', '.$experience.'</h5>';
            $postList .= '</div>';
            $postList .= '<div class="content-nbox">';
            $postList .= '<div class="post-desc">'.$post_content.'</div>';
            $postList .= '</div>';
            $postList .= '</div>';
            $postList .= '</li>';
        }
    $html .='<ul class="ntype-list testimonial-list-template slick-testimonial-list custom-slick-template">'.$postList.'</ul>';
    else:
        echo "no post";
    endif;

    return $html; 
    wp_reset_query();
}