<?php
/**
 * The template for displaying Search Results pages.
 * @package ninja
 */

get_header(); ?>

	<section id="primary" class="content-area search">
		<main id="main" class="site-main nvm30" role="main">
		<div class="container">
		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<h2 class="page-title"><?php printf( esc_html__( '搜寻关键字: %s', 'ninja' ), '<span class="search-keyword">' . get_search_query() . '</span>' ); ?></h2>
			</header><!-- .page-header -->

			<?php /* Start the Loop */ ?>

			<section class="search-results-list">
			<?php while ( have_posts() ) : the_post(); ?>

				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="blog-item-wrap">
						<div class="post-inner-content">

							<header class="entry-header page-header">
								<h2 class="entry-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
							</header><!-- .entry-header -->
							
							<div class="entry-summary">
								<?php the_excerpt(); ?>
								<p><a class="elementor-button" href="<?php the_permalink(); ?>"><?php esc_html_e( '了解更多', 'ninja' ); ?></a></p>
							</div><!-- .entry-summary -->

						</div>
					</div>
				</article>

			<?php endwhile; ?>

			</section>

			<?php do_action('ninja_navigation'); ?>

		<?php else : ?>

			<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'ninja' ); ?></p>
			<?php get_search_form(); ?>

		<?php endif; ?>
		</div>
		</main><!-- #main -->
	</section><!-- #primary -->

<?php get_footer(); ?>